package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.OrgDTO;
import gov.va.med.mhv.admin.model.Org;

@Component
public class OrgConverter {

	public static OrgDTO convert(Org org) {

		OrgDTO orgDTO = new OrgDTO();
		orgDTO.setFacilityInfoId(org.getFacilityInfoId());
		orgDTO.setName(org.getName());
		orgDTO.setOplock(org.getOplock());
		orgDTO.setOrgId(org.getId());
		orgDTO.setTypeOfOrganization(org.getTypeOfOrganization());
		orgDTO.setParentOrganization(org.getParentOrganization());
		return orgDTO;
	}

	public List<OrgDTO> convert(List<Org> source) {

		List<OrgDTO> destination = new ArrayList<OrgDTO>();
		for (Org a : source) {
			destination.add(convert(a));
		}
		return destination;
	}

	public static Org convert(OrgDTO orgDTO) {

		Org org = new Org();
		org.setFacilityInfoId(orgDTO.getFacilityInfoId());
		org.setName(orgDTO.getName());
		org.setOplock(orgDTO.getOplock());
		org.setId(orgDTO.getOrgId());
		org.setTypeOfOrganization(orgDTO.getTypeOfOrganization());
		org.setParentOrganization(org.getParentOrganization());
		return org;
	}

}
